

<?php
class Download_reg_card extends MY_Controller
{
    public $module_name;
	function __construct()
	{
        parent::__construct();
        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Reg_card_model');

        $view_data['menu_on'] = true;       
        $this->load->vars($view_data);
	}

	function index(){
		$this->download_tomorrow_registrations();
	}

    function reg_card_report($date = null){

        $date = (isset($date)) ? $date : $this->selling_date;
        
        $data['date'] = $date;

        // $selling_date = $this->selling_date;

        // $tomorrow = date('Y-m-d', strtotime($selling_date . " + 1 day"));

        // Load bookings with check-in = tomorrow
        $bookings = $this->Reg_card_model->get_bookings_by_checkin_date($date);
// prx($bookings);
        usort($bookings, function ($a, $b) {
            return strtotime($a['check_in_date']) <=> strtotime($b['check_in_date']);
        });

        if (empty($bookings)) {
            echo "No bookings found for tomorrow.";
            return;
        }

        $data['bookings'] = $bookings;

        $data['main_content'] = '../extensions/'.$this->module_name.'/views/reg_card_report';
        $this->template->load('bootstrapped_template', null , $data['main_content'], $data);

    }

	public function download_tomorrow_registrations($date = null)
    {
        $this->load->model('Payment_model');
        $this->load->model('Customer_field_model');
        $this->load->model('Customer_model');
        // $selling_date = $this->selling_date;

        // $tomorrow = date('Y-m-d', strtotime($selling_date . " + 1 day"));

        // // Load bookings with check-in = tomorrow
        // $bookings = $this->Reg_card_model->get_bookings_by_checkin_date($selling_date, $tomorrow);

        $date = (isset($date)) ? $date : $this->selling_date;
        
        $data['date'] = $date;

        // Load bookings with check-in = tomorrow
        $bookings = $this->Reg_card_model->get_bookings_by_checkin_date($date);

        usort($bookings, function ($a, $b) {
            return strtotime($a['check_in_date']) <=> strtotime($b['check_in_date']);
        });

        if (empty($bookings)) {
            echo "No bookings found for tomorrow.";
            return;
        }

        $data['check_in_policies'] = $this->Company_model->get_check_in_policies($this->company_id);

        $data['company'] = $this->company_data;
        $data['customer_fields'] = $this->Customer_field_model->get_customer_fields_for_registration_card($this->company_id);

        $common_customer_fields = json_decode(COMMON_CUSTOMER_FIELDS, true);
        $get_common_customer_fields = $this->Customer_field_model->get_common_customer_fields_settings($this->company_id);

        foreach($common_customer_fields as $id => $name)
        {
            $data['common_customer_fields'][] = array(
                'id' => $id,
                'name' => $name,
                'company_id' => $this->company_id,
                'show_on_customer_form'=> ($get_common_customer_fields && isset($get_common_customer_fields[$id]) && isset($get_common_customer_fields[$id]['show_on_customer_form'])) ? $get_common_customer_fields[$id]['show_on_customer_form'] : 1,
                'show_on_registration_card'=>  ($get_common_customer_fields && isset($get_common_customer_fields[$id]) && isset($get_common_customer_fields[$id]['show_on_registration_card'])) ? $get_common_customer_fields[$id]['show_on_registration_card'] : 0,
                'is_required' => ($id == FIELD_NAME) ? 1 : (($get_common_customer_fields && isset($get_common_customer_fields[$id]) && isset($get_common_customer_fields[$id]['is_required'])) ? $get_common_customer_fields[$id]['is_required'] : 0),
                'show_on_in_house_report' => ($get_common_customer_fields && isset($get_common_customer_fields[$id]) && isset($get_common_customer_fields[$id]['show_on_in_house_report'])) ? $get_common_customer_fields[$id]['show_on_in_house_report'] : 0
            );
            $common_name = strtolower($name);
            $cn = "";
            if(isset($data['customer'][$common_name]) && $data['customer'][$common_name] != '')
            {
                $data['customer']['customer_fields'][$id] = $data['customer'][$common_name];
            }
            elseif(isset($data['customer']['customer_'.$common_name]) && $data['customer']['customer_'.$common_name] != '')
            {
                $data['customer']['customer_fields'][$id] = $data['customer']['customer_'.$common_name];
            }
            else
            {
                $explode_name = explode(' ',$common_name);
                $cn = $explode_name[0].''.(isset($explode_name[1]) && $explode_name[1] ? $explode_name[1] : '');
                if(isset($data['customer'][$cn]) && $data['customer'][$cn] != '')
                {
                    $data['customer']['customer_fields'][$id] = $data['customer'][$cn];
                }
                else
                {
                    $cn = (isset($explode_name[0]) && $explode_name[0] ? $explode_name[0] : '').'_'.(isset($explode_name[1]) && $explode_name[1] ? $explode_name[1] : '');
                    if(isset($data['customer'][$cn]) && $data['customer'][$cn] != "") {
                        if($cn == 'customer_type') {
                            $cn = 'customer_type_id';
                            $this->load->model('Customer_type_model');
                            $customer_type = $this->Customer_type_model->get_customer_type($data['customer'][$cn]); 
                            $data['customer']['customer_fields'][$id] = $customer_type[0]['name'] ?? null;
                        } else {
                            $data['customer']['customer_fields'][$id] = $data['customer'][$cn];
                        }
                    }
                }
            }
        }

        foreach ($data['common_customer_fields'] as $key => $value) {
            if($value['show_on_registration_card'])
                $data['customer_fields'][] = $value;
        }

        // if booking is using rate plan, get the rate of the check-in date of the booking

        foreach($bookings as $index => $booking) {

            $booking_id = $booking['booking_id'];

            $check_in = new DateTime($booking['check_in_date']);
            $check_out = new DateTime($booking['check_out_date']);
            $number_of_days = $check_in->diff($check_out)->days;

            if ($booking['use_rate_plan'] == 1)
            {
                $rate_array = $this->rate->get_rate_array(
                    $booking['rate_plan_id'],
                    $booking['check_in_date'],
                    $booking['check_out_date'],
                    $booking['adult_count'],
                    $booking['children_count']
                );
                if(isset($rate_array[0]))
                {
                    $booking['rate'] = $rate_array[0]['rate'];
                }
            }

            $payment_details = $this->Payment_model->get_payments($booking_id);
            $total_payment = 0;

            if($payment_details) {
                foreach ($payment_details as $payment) {
                    $total_payment += $payment['amount'];
                }
            }
            $booking['charge_total'] = (float)$booking['balance'] + $total_payment;

            $bookings[$index]['charge_total'] = $booking['charge_total'];
            
            $charge_type_id = $booking['charge_type_id'];
            if($booking['use_rate_plan'] == 1){
                $rate_plan = $this->Reg_card_model->get_rate_plan($booking['rate_plan_id']);
                
                $charge_type_id = $rate_plan['charge_type_id'];
            }

            $tax = $this->get_tax_amount_from_room_charge_JSON($charge_type_id, $booking['rate']);

            $booking['total_tax'] = (($booking['rate'] * floatval($tax['percentage'])) * $number_of_days );

            $bookings[$index]['total_tax'] = $booking['total_tax'];

            $staying_customers = $this->Customer_model->get_staying_customers($booking_id);

            $bookings[$index]['staying_customers'] = $staying_customers;

        }
        $data['reg_data'] = $bookings;

        // Load view content
        $html = $this->load->view('../extensions/'.$this->module_name.'/views/registration_cards_batch', $data, true);


        $this->load->library('pdf');

        if (ob_get_length()) ob_end_clean();

        $this->pdf->writeHTML($html);
        $this->pdf->Output('registration_cards_' . $tomorrow . '.pdf', 'D');
        exit;
    }

    function get_tax_amount_from_room_charge_JSON($charge_type_id, $rate) {
        $tax = $this->_get_tax_amount_from_charge_type_id($charge_type_id, null, $rate);
        return $tax;
    }

    function _get_tax_amount_from_charge_type_id($charge_type_id, $company_id = null, $rate = null)
    {
        $this->load->model('Tax_model');
        $tax = array();
        $tax['percentage'] = 0.01 * $this->Tax_model->get_total_tax_percentage_by_charge_type_id($charge_type_id, $company_id, $rate);
        $tax['inclusive_tax_percentage'] = 0.01 * $this->Tax_model->get_total_tax_percentage_by_charge_type_id($charge_type_id, $company_id, $rate, $is_tax_inclusive = true);
        $tax['flat_rate'] = $this->Tax_model->get_total_tax_flat_rate_by_charge_type_id($charge_type_id, $company_id, $rate);
        $tax['inclusive_tax_flat_rate'] = $this->Tax_model->get_total_tax_flat_rate_by_charge_type_id($charge_type_id, $company_id, $rate, $is_tax_inclusive = true);
        $tax['charge_type_id'] = $charge_type_id;
        return $tax;
    }
}

